IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CP_SCA_ValidoAccesoAcompananteVisita') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CP_SCA_ValidoAccesoAcompananteVisita
END
GO

CREATE PROCEDURE [dbo].[CP_SCA_ValidoAccesoAcompananteVisita]	@pId_Cliente							INT,
																@pFecha									DATETIME,
																@pId_Controlador						SMALLINT,
																@pId_Acceso								SMALLINT,
																@pFlag_TipoValidacionUCP				TINYINT,
																@Flag_AccesoPermitidoAcompananteVisita	TINYINT OUTPUT
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @Habilitado INT = 0

    SELECT @Flag_AccesoPermitidoAcompananteVisita = 
        CASE 
            WHEN EXISTS (
                SELECT 1 
                FROM Clientes_Invitados_Mov 
                WHERE CONVERT(DATE, Fecha) <= CONVERT(DATE, @pFecha) 
                  AND CONVERT(DATE, Fecha_Hasta) >= CONVERT(DATE, @pFecha)
                  AND Id_Cliente = @pId_Cliente
            ) THEN 1 
            ELSE 0 
        END

    IF (@pFlag_TipoValidacionUCP = 1)
    BEGIN
        SET @Habilitado = 
        CASE 
            WHEN EXISTS (
                SELECT 1
                FROM Clientes_Invitados_Mov CIM
                INNER JOIN Clientes L ON CIM.Id_Cliente_D = L.Id_Cliente
                WHERE CONVERT(DATE, Fecha) <= CONVERT(DATE, @pFecha)
                  AND CONVERT(DATE, Fecha_Hasta) >= CONVERT(DATE, @pFecha)
                  AND CIM.Id_Cliente = @pId_Cliente
                  AND dbo.CF_SCA_ValidarUltCuotaPaga(CIM.Id_Cliente_D, @pId_Acceso, @pFecha) = 1
            ) THEN 1 
            ELSE 0 
        END

        IF (@Habilitado = 1)
        BEGIN
            SET @Flag_AccesoPermitidoAcompananteVisita = 1
        END
        ELSE
        BEGIN
            SET @Flag_AccesoPermitidoAcompananteVisita = 0
        END
    END

    RETURN ISNULL(@Flag_AccesoPermitidoAcompananteVisita, 0)
END
